#/bin/sh

set -e

echo "Unwrapping paragraphs."
fmt -w 2000 < scarlet_moon.tw > scarlet_moon_unwrapped.tw
fmt -w 2000 < ep1.tw > ep1_unwrapped.tw
fmt -w 2000 < ep2.tw > ep2_unwrapped.tw
fmt -w 2000 < ep3.tw > ep3_unwrapped.tw
if [[ $1 ]]
then
    echo "Generating test HTML."
    tweego/tweego -t ep1_unwrapped.tw ep2_unwrapped.tw ep3_unwrapped.tw scarlet_moon_unwrapped.tw -o test_scarlet_moon.html
else
    echo "Generating final game, Twine archive and zipped source."
    tweego/tweego ep1_unwrapped.tw ep2_unwrapped.tw ep3_unwrapped.tw scarlet_moon_unwrapped.tw -o deploy/scarlet_moon.html
    tweego/tweego -a ep1_unwrapped.tw ep2_unwrapped.tw ep3_unwrapped.tw scarlet_moon_unwrapped.tw -o deploy/scarlet_moon_archive.html
    cp scarlet_moon.tw deploy/source/.
    cp ep1.tw deploy/source/.
    cp ep2.tw deploy/source/.
    cp ep3.tw deploy/source/.
    cp deploy/scarlet_moon.html deploy/source/.
    cp deploy/scarlet_moon_archive.html deploy/source/.
    cp compile.sh deploy/source/.
    cp README.md deploy/source/.
    zip -r deploy/scarlet_moon_source.zip deploy/source
fi
echo "Removing temporary files."
rm *_unwrapped.tw
echo "Done!"
